import os

from core.models.multi_value_mdl import MultiValueModel
from core.components.logger import Logger
from core.utils.general_utils import AttrDict
from core.configs.default_data_configs.dmcontrol import data_spec
from core.components.evaluator import ImageEvaluator, MultiImageEvaluator
from core.data.src.data_loaders import DMControlRescaleDataset


current_dir = os.path.dirname(os.path.realpath(__file__))


configuration = {
    'model': MultiValueModel,
    'model_test': MultiValueModel,
    'logger': Logger,
    'logger_test': Logger,
    'evaluator': MultiImageEvaluator,
    'data_dir': os.path.join(os.environ['DATA_DIR'], './distracting_control/walker/expert_L10'),
    'num_epochs': 100,
    'epoch_cycles_train': 7,
    'batch_size': 128,
    'discount_factor': 0.99,
    'n_frames': 3,
    'lr': 1e-4,
}
configuration = AttrDict(configuration)

model_config = {
    'img_sz': 64,
    'nz_enc': 256,
    'nz_mid': 256,
    'input_nc': 9,
    'normalization': 'none',
}

# Dataset
data_config = AttrDict()
data_config.dataset_spec = data_spec
data_config.dataset_spec.task_names = ['walk-expert', 'stand-expert', 'backward-expert']
data_config.dataset_spec.discount_factor = 0.4
# data_config.dataset_spec.dataset_class = DMControlRescaleDataset
